// Title      : Post.java
// Author     : James Baird
// Created    : Monday, 23rd June 2003
// Description: Representation of a post

import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Post extends DefaultHandler
{
  Post(Group group, int id)
  {
    this.group = group;
    this.id = id;
  }
  
  public String getSubject()
  {
    return subject;
  }
  
  public int getLength()
  {
    return body.size();
  }

  public Vector getBody()
  {
    return body;
  }

  public void startDocument() throws SAXException
  {
    state = "post";
    
    header = new Vector();
    
    body = new Vector();
  }
  
  public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
  {
    if (state.equals("post"))
    {
      if (qName.equals("post"))
      {
        if (attributes.getValue("id").equals(Integer.toString(id)))
        {
          subject = attributes.getValue("subject");
          
          state = "header";
        }
      }
    }
    else if (state.equals("header") || state.equals("body"))
    {
      if (qName.equals("paragraph"))
        paragraph = "";
    }
  }
  
  public void endElement(String uri, String localName, String qName) throws SAXException
  {
    if (state.equals("header"))
    {
      if (qName.equals("paragraph"))
        header.addElement(paragraph);
      else if (qName.equals("header"))
        state = "body";
    }
    else if (state.equals("body"))
    {
      if (qName.equals("paragraph"))
        body.addElement(paragraph);
      if (qName.equals("post"))
        state = "ignore";
    }
  }
  
  public void characters(char[] ch, int start, int length) throws SAXException
  {
    if (state.equals("header") || state.equals("body"))
      paragraph += new String(ch, start, length);
  }
  
  public String toString()
  {
    StringBuffer result = new StringBuffer();
    
    result.append("*** POST group" + group.getName() + " vol " + group.getVolume() + " id " + id + " len " + body.size());
    result.append(System.getProperty("line.separator"));
    
    for (int i = 0; i < header.size(); i++)
    {
      String element = (String)header.elementAt(i);

      if (element.startsWith("From:") || element.startsWith("Subject:") || element.startsWith("Date:"))
      result.append(element + System.getProperty("line.separator"));
    }
      
    result.append("--" + System.getProperty("line.separator"));
    
    for (int i = 0; i < body.size(); i++)
      result.append(body.elementAt(i) + System.getProperty("line.separator"));
    
    return result.toString();
  }
  
  private Group group;
  private int id;
  private String subject;
  private Vector header;
  private Vector body;
  
  private String state;
  private String paragraph;
}
